% Image Inpainting via Tensor Completion

clear
clc
rng('default')
addpath('cset8/');
M          = double(imread('lena.png'));
M          = M/255;
maxP       = max(abs(M(:)));
[n1,n2,n3] = size(M);
L          = dct(eye(n2));

p = 0.5;
List = rand(n1*n2*n3,1);
omega = find(List<p);
Omega          = zeros(n1,n2,n3);
Iones          = ones(n1,n2,n3);
Omega(omega)   = Iones(omega);
Data           = Omega.*M;

% considering as a tensor in h x 3 x w for a image with size h x w
M2     = Frontal2Lateral(M);
Data2  = Frontal2Lateral(Data);
Omega2 = Frontal2Lateral(Omega);

% a natural image is an approximately low-rank tensor 
% but not a strictly low-rank tensor
opts.maxiter   = 100;
opts.lambdamax = 100;
opts.lambdamin = 1e-3;
opts.mu        = 0.99;
opts.rho       = 0.8;
opts.tau       = 10;
opts.delta     = 100;
opts.tol       = 1e-2;

tic
[X,Y,iter,out] = lrtc(M2,Data2,Omega2,L,opts);
toc


X    = max(X,0);
X    = min(X,maxP);
X    = Lateral2Frontal(X);
psnr = psnr(M,X,maxP)


figure(1)
subplot(1,3,1)
imshow(M)
subplot(1,3,2)
imshow(Data)
subplot(1,3,3)
imshow(X)